
ALLOWED_TYPE = "soft_install"  # 允许的信息详情类型


def init_db():
    import public
    from db import Sql

    db = Sql()
    db.dbfile("msg_box")
    create_sql_str = (
        "CREATE TABLE IF NOT EXISTS 'soft_install' ("
        "id INTEGER PRIMARY KEY AUTOINCREMENT, "
        "pid INTEGER NOT NULL UNIQUE DEFAULT 0, "
        "task_id INTEGER NOT NULL DEFAULT 0, "
        "soft_name TEXT NOT NULL DEFAULT '', "
        "install_status TEXT NOT NULL DEFAULT '', "
        "status INTEGER NOT NULL DEFAULT 0, "
        "file_name TEXT NOT NULL DEFAULT ''"
        ");"
    )
    res = db.execute(create_sql_str)
    if isinstance(res, str) and res.startswith("error"):
        public.WriteLog("消息盒子", "建表soft_install失败")
        return

    index_sql_str = "CREATE INDEX IF NOT EXISTS 'soft_install_index' ON 'soft_install' ('pid');"

    res = db.execute(index_sql_str)
    if isinstance(res, str) and res.startswith("error"):
        public.WriteLog("消息盒子", "为soft_install建立索引soft_install_index失败")
        return

